<?PHP  if ( ! defined('BASEPATH')) exit('No direct script access allowed');
/**
* @package direct-project-innovation-initiative
* @subpackage libraries
*/ /** */

require_once APPPATH.'libraries/attachment.php';

/**
* @package direct-project-innovation-initiative
* @subpackage libraries
*/
class Word_attachment extends Attachment{

	/**
	* Creates a PDF version of this Word attachment and returns it as an attachment object.
	* @return PDF_attachment
	*/
	public function to_pdf(){
		if(!USE_DOC_TO_PDF_CONVERSION_PROCESS) return false;

		$CI = get_instance();

		// add attachement to cache.
		if(!$CI->user->add_file_to_system_cache($this->name, $this->binary_string)){
			$this->error->warning('Unable to convert '.$this->describe().' to PDF: could not write '.$this->name.' to system cache');
		}

		//create pdf output and reference filename
		$pdf_name = replace_last_with($this->extension, 'pdf', $this->name);
		$pdf_path = $CI->user->system_cache().$pdf_name;

		//Try calling LibreOffice from the command line directly if we want to do this as per constants
# Code review note - can we do the COM check first and try using the command line if the COM library isn't available/fails?  -- MG 2015-01-08
		if(USE_COMMAND_LINE_DOC_TO_PDF) {
			try {
				$this->convert_to_pdf($CI->user->system_cache().$this->name, $CI->user->system_cache());
			}
			catch(Exception $e){
				return $this->error->warning('Unable to convert '.$this->describe().' to PDF: '.$e->getMessage());
			}
		}
		else {
			//use preexisting method in conversion engine to convert word attachments to pdf
			 if(!class_exists('COM')) return $this->error->warning('Unable to convert '.$this->describe().' to PDF: COM library is not available'); //fail gracefully if COM is not available on this server
			try{
				$helper = new COM("newPDFConversion.Class1");
				$helper->convert_to_pdf(escapeshellarg($CI->user->system_cache().$this->name),$CI->user->system_cache());
			}
			catch(Exception $e) {
				return $this->error->warning('Unable to convert with COM Object '.$this->describe().' to PDF: '.$e->getMessage());
			}
		}

		if(!file_exists($pdf_path))
			return $this->error->warning('Unable to convert '.$this->describe().' to PDF: '.$pdf_path.' was not created successfully.');

		return PDF_attachment::create($pdf_name, file_get_contents($pdf_path), array('directory' => $CI->user->system_cache()));
	}


	public function view(){
		if(!USE_DOC_TO_PDF_CONVERSION_PROCESS) return $this->download();

		//convert this Word document to PDF
		$pdf = $this->to_pdf();

		//if the conversion worked, display the PDF
		if(is_a($pdf, 'PDF_attachment'))
			return $pdf->view();

		//default to downloading the document if we ran into problems.
		return $this->download();
	}

	public function view_inline(){
		if(!USE_DOC_TO_PDF_CONVERSION_PROCESS) return $this->download();

		//convert this Word document to PDF
		$pdf = $this->to_pdf();

		//if the conversion worked, display the PDF
		if(is_a($pdf, 'PDF_attachment'))
			return $pdf->view_inline();

		//default to downloading the document if we ran into problems.
		return $this->download();
	}

////////////////////////
// PROTECTED FUNCTIONS
///////////////////////

	//Calls the command line for LibreOffice to convert the document to PDF
	protected function convert_to_pdf($source_path, $pdf_path) {
		if(!get_instance()->is->file_path($source_path)) return get_instance()->error->should_be_an_existing_file_path($source_path);
		if(!get_instance()->is->string_like_a_file_path($pdf_path)) return get_instance()->error->should_be_a_file_path($pdf_path);

#TODO - Consider writing a helper function to allow us to add a timeout exec calls, in case it hangs for some reason
		//Please look into some ways to handle a stalled process for the command line, even if it's just logging a PHP error noting that something went wrong.
		//If it's not possible, please add an explanation to the code and the JIRA ticket.


		// set as a constant_path
		$startDir = "C:\Program Files (x86)\LibreOffice 4\program";
		$runExe   = 'soffice';
		$envars   = ' --headless --nofirststartwizard -convert-to pdf -outdir '. escapeshellarg($pdf_path).' '. escapeshellarg($source_path);

		$runPath = $runExe .' '. $envars;


		chdir($startDir);

		$descriptorspec = array (
				0 => array("pipe", "r"),
				1 => array("pipe", "w"),
		);
		//set this as a constant
		$timeout = 5; //5 seconds
		$start_time = time();

		if ( is_resource( $prog = proc_open("start /wait " . $runPath, $descriptorspec, $pipes, $startDir, NULL) ) )
		{
			$this->error->warning('here');
			while(time() < $start_time +$timeout)
			{
				//$ppid = proc_get_status($prog)['pid'];
				$ppid = proc_get_status($prog);
				if ($ppid['running']){
					$this->error->warning('Command-line conversion is still running for file '. $source_path );
					sleep(1);
				}
				else{
					$this->error->warning('Command-line conversion is NOT running');
					return true;
				}
			}
			$this->error->warning('Command-line conversion is OVER!!! or conversion timed-out');
			proc_terminiate($prog);
			return false;
		}
		else{ throw new Exception('Command-line conversion of Word Document to PDF failed.'); }
	}




/////////////////////
// STATIC FUNCTIONS
/////////////////////

	public static function create($name, $binary_string, $more_values = array()){
		if(empty($binary_string)) return get_instance()->error->should_be_an_x('name of a '.humanize(get_called_class()), $name);
		if(!static::matches_file($name, $binary_string)) return get_instance()->error->should_be_an_x('name of a '.humanize(get_called_class()), $name);
		return new Word_attachment(array_merge(compact('name', 'binary_string'), $more_values));
	}

	public static function matches_file($name, $binary_string){
		if(!parent::matches_file($name, $binary_string)) return false;
		return in_array(strtolower(pathinfo($name, PATHINFO_EXTENSION)), array('doc', 'docx'));
	}

}
?>